# How to become a contributor and submit your own code

## Contributor License Agreements

We'd love to accept your sample apps and patches! Before we can take them, we 
have to jump a couple of legal hurdles.

Please fill out either the individual or corporate Contributor License Agreement
(CLA).

  * If you are an individual writing original source code and you're sure you
    own the intellectual property, then you'll need to sign an [individual CLA]
    (http://code.google.com/legal/individual-cla-v1.0.html).
  * If you work for a company that wants to allow you to contribute your work,
    then you'll need to sign a [corporate CLA]
    (http://code.google.com/legal/corporate-cla-v1.0.html).

Follow either of the two links above to access the appropriate CLA and
instructions for how to sign and return it. Once we receive it, we'll be able to
accept your pull requests.

## Contributing a Patch

1. Sign a Contributor License Agreement, if you have not yet done so (see
   details above).
1. Create your change to the repo in question.
    * Fork the desired repo, develop and test your code changes.
    * Ensure that your code is clear and comprehensible.
    * Ensure that your code has an appropriate set of unit tests which all pass.
1. Submit a pull request.
1. The repo owner will review your request. If it is approved, the change will
   be merged. If it needs additional work, the repo owner will respond with
   useful comments.
